package drm.micro;

import robocode.*;
import java.util.*;

public class AVB extends AdvancedRobot
{
	// Properties
	static double   oppEnergy;
	static long     movementTime;
	static double   aheadDist;
	static Vector   bulletStoreList;
	static int      reverseInt      = 1;
	static Random   random          = new Random();
//	static int[]    offsetStore     = new int[120];
	static int[][]  offsetStore     = new int[5][120];
	
	// Methods
	public void run() {
//		setAdjustGunForRobotTurn(true);
		movementTime    = 0L;
		oppEnergy       = 100D;
		bulletStoreList = new Vector();
		do{
			turnRadarRightRadians(1);
		}while(true);
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double oppBulletPower  = oppEnergy - (oppEnergy = e.getEnergy());
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		double distance        = e.getDistance();
		double sign            = random.nextDouble();	// Temporary use.
		double bulletPower     = Math.min(3D, Math.min(getEnergy() / 10.0, oppEnergy / 4.0));
		BulletStore bs;

		// decide stop.
		if ((getTime() > movementTime)
		   || (chkOutOfBattleField(Math.toRadians(getHeading() + (reverseInt - 1) * -90), 70))
		   || (sign < 0.01))
			aheadDist = 0;

		// turn body and decide movement speed.
		if (aheadDist == 0D) {
			setTurnRightRadians(Math.toRadians(e.getBearing() + 90 + distance / 50 * reverseInt));
			if (oppBulletPower > 0D){
				reverseInt   = - reverseInt;
				movementTime = getTime()
				   + (long)(distance / (20D - 3D * oppBulletPower));
				aheadDist = (sign * 12D + 12D)  * reverseInt;
			}
		}

		// accelerate.
		setAhead(aheadDist);

		// turn radar.
		setTurnRadarRightRadians(3D * Math.sin(absoluteBearing - getRadarHeadingRadians()));

		// turn gun.
		sign = Math.sin(e.getHeadingRadians() - absoluteBearing);
		if (e.getVelocity() < 0) sign = -sign;
//		setTurnGunRightRadians(Math.sin(absoluteBearing - getGunHeadingRadians() + recalcOffset() * sign));
		setTurnGunRightRadians(Math.sin(absoluteBearing - getGunHeadingRadians() +
		   recalcOffset(Math.min(4, (int)(distance / 100D))) * sign));
//out.println("ecalcOffset()=" + recalcOffset());
//out.println("sign=" + sign);
		// shoot.
		if  (getEnergy() > .1 &&  setFireBullet(bulletPower) != null){
			// make bullet store.
				bs = new BulletStore();
				bs.x               = getX();
				bs.y               = getY();
				bs.absoluteBearing = absoluteBearing;
				bs.running         = -10D;
				bs.sign            = sign;
				bs.velocity        = 20D - 3D * bulletPower;
				bs.distanceID      = Math.min(4, (int)(distance / 100D));
				bulletStoreList.addElement(bs);
		}

		// check bullet stores.
		Enumeration en = bulletStoreList.elements();
		while(en.hasMoreElements()){
			bs = (BulletStore)en.nextElement();
			bs.running += bs.velocity;
			if (bs.running > distance){
				// update offsetStore.
/*
				offsetStore
				   [Math.max(0, Math.min(119, (int)(Math.asin(Math.sin(Math.atan2(
				   distance * Math.sin(absoluteBearing) + getX() - bs.x, 
				   distance * Math.cos(absoluteBearing) + getY() - bs.y) - bs.absoluteBearing))
				   / bs.sign * 20D + 60D)))] ++;
*/
				offsetStore[bs.distanceID]
				   [Math.max(0, Math.min(119, (int)(Math.asin(Math.sin(Math.atan2(
				   distance * Math.sin(absoluteBearing) + getX() - bs.x, 
				   distance * Math.cos(absoluteBearing) + getY() - bs.y) - bs.absoluteBearing))
				   / bs.sign * 20D + 60D)))] ++;
				bulletStoreList.removeElement(bs);
			}
		}
		execute();
	}
/*
	double recalcOffset(){
		int tmp1 = 60;
		int tmp2 = 0;
		for(int i = 0; offsetStore.length > i; i++)
			if (offsetStore[i] > tmp2){
				tmp1 = i;
				tmp2 = offsetStore[i];
			}
		return ((double)(tmp1 - 60) / 60D * Math.PI);
	}
*/
	double recalcOffset(int tmp1){
		int[] tmp = offsetStore[tmp1];
		tmp1      = 60;
		int tmp2  = 0;
		for(int i = 0; tmp.length > i; i++)
			if (tmp[i] > tmp2){
				tmp1 = i;
				tmp2 = tmp[i];
			}
		return ((double)(tmp1 - 60) / 20D);
	}
	boolean chkOutOfBattleField(double headingRadians, double distance){
		double x = getX() + distance * Math.sin(headingRadians);
		double y = getY() + distance * Math.cos(headingRadians);
		return ((x < 0) || (x > getBattleFieldWidth()) || (y < 0) || (y > getBattleFieldHeight()));
	}
}
